/*
 * This file contains all the functions related to the Waveform Screen for Channel 2
 * */
#include <math.h>
#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>
#include <stdlib.h>
#include <string.h>
#include "inc/hw_memmap.h"
#include "inc/hw_gpio.h"
#include "inc/hw_nvic.h"
#include "inc/hw_sysctl.h"
#include "inc/hw_types.h"
#include "driverlib/fpu.h"
#include "driverlib/gpio.h"
#include "driverlib/flash.h"
#include "driverlib/sysctl.h"
#include "driverlib/systick.h"
#include "driverlib/uart.h"
#include "driverlib/udma.h"
#include "driverlib/rom.h"
#include "grlib/grlib.h"
#include "grlib/widget.h"
#include "grlib/canvas.h"
#include "grlib/checkbox.h"
#include "grlib/container.h"
#include "grlib/pushbutton.h"
#include "grlib/radiobutton.h"
#include "grlib/slider.h"

#include "lcd_tools/Kentec320x240x16_ssd2119_spi.h"
#include "lcd_tools/touch.h"



#include "DisplayWaveformCh2.h"
//#include "home_screen.h"
#include "InitializeFunctions.h"


//variable for zooming the displed waveform
short zoom_scaleCh2 = 1;
// variable for storing the y-coordiante of the printing screen
int y_axisCh2[MAX_SAMPLES], y_axis_zoomedCh2[MAX_SAMPLES];

// Buttons in the waveform channel 2 screen
RectangularButton(backHomeButWFSCh2, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 80,
                  195, 80, 44, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL,
                  BUT_PRESS, 0, BUT_TEXT_COLOR, &g_sFontCm20, "HOME", 0, 0, 0,
                  0, backHomeButWFSFuncCh2);

RectangularButton(endCh2But, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 240,
                  195, 80, 44, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL,
                  BUT_PRESS, 0, BUT_TEXT_COLOR, &g_sFontCm20, "END", 0, 0, 0,
                  0, endCh2ButFunc);

RectangularButton(backFAButWFSCh2, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 0, 195,
                  80, 44, PB_STYLE_FILL | PB_STYLE_TEXT, BUT_NORMAL, BUT_PRESS,
                  0, BUT_TEXT_COLOR, &g_sFontCm20, "BACK", 0, 0, 0, 0,
                  backFAButWFSFuncCh2);

// Buttons for zoomin and zoomout in the waveform screen (NOT VISIBLE on the display)
RectangularButton(zoomIncButCh2, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 0, 30, 50,
                  100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, zoomIncButFunCh2);
RectangularButton(zoomDecButCh2, 0, 0, 0, &g_sKentec320x240x16_SSD2119, 269, 30,
                  50, 100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, zoomDecButFunCh2);

// call back function for Back to home button in waveform channel 2 screen
void backHomeButWFSFuncCh2(tWidget *psWidget)
{
    WidgetRemove((tWidget*) &backHomeButWFSCh2);
    WidgetRemove((tWidget*) &endCh2But);
    WidgetRemove((tWidget*) &backFAButWFSCh2);
    WidgetRemove((tWidget*) &zoomIncButCh2);
    WidgetRemove((tWidget*) &zoomDecButCh2);

    clr_scrn_total();

    homeScreen();
}

// call back function for Back to frequency and amplitude select screen - 2 button in waveform channel 2 screen
void backFAButWFSFuncCh2(tWidget *psWidget)
{
    WidgetRemove((tWidget*) &backHomeButWFSCh2);
    WidgetRemove((tWidget*) &backFAButWFSCh2);
    WidgetRemove((tWidget*) &zoomIncButCh2);
    WidgetRemove((tWidget*) &zoomDecButCh2);
    WidgetRemove((tWidget*) &endCh2But);

    clr_scrn_total();

    freqAmpSelScreenCh2();
}

// call back function for going to DESE screen
void endCh2ButFunc(tWidget *psWidget)
{
    WidgetRemove((tWidget*) &backHomeButWFSCh2);
    WidgetRemove((tWidget*) &backFAButWFSCh2);
    WidgetRemove((tWidget*) &zoomIncButCh2);
    WidgetRemove((tWidget*) &zoomDecButCh2);
    WidgetRemove((tWidget*) &endCh2But);

    clr_scrn_total();
    screenChar = 'a';

    GrImageDraw(&sContext, g_DESElogoImage, 0, 0);
    GrFlush(&sContext);
}

// display waveform function for channel - 2
void displayWaveScreenCh2()
{
    screenChar = 'e';
    clr_scrn_total();

    includeZoomFuncCh2();

    WidgetAdd(WIDGET_ROOT, (tWidget*) &backHomeButWFSCh2);
    WidgetPaint((tWidget* )&backHomeButWFSCh2);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &backFAButWFSCh2);
    WidgetPaint((tWidget* )&backFAButWFSCh2);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &endCh2But);
    WidgetPaint((tWidget* )&endCh2But);

    makeRect(&FuncGenRect, 0, 0, 319, 14, RECT_FOREGROUND_COLOR,
             "FUNCTION GENERATOR");
    makeRect(&WFCh2Rect, 160 , 194, 239, 239, RECT_FOREGROUND_COLOR,
             "Ch2 Wave");
}

//all the zooming work for channel 2
// call back function for zooming in in channel 2
void zoomIncButFunCh2(tWidget *psWidget)
{
    zoom_scaleCh2 = zoom_scaleCh2 * 2;
    if (zoom_scaleCh2 >= 16)
    {
        zoom_scaleCh2 = 16; // maximum zoom limit is 16
    }
    print_waveform_ch2();
}

// call back function for zooming out channel 2
void zoomDecButFunCh2(tWidget *psWidget)
{
    zoom_scaleCh2 = zoom_scaleCh2 / 2;
    if (zoom_scaleCh2 <= 1)
    {
        zoom_scaleCh2 = 1; // minimum zoom limit is 1
    }
    print_waveform_ch2();
}

void includeZoomFuncCh2()
{
    WidgetAdd(WIDGET_ROOT, (tWidget*) &zoomIncButCh2);
    WidgetPaint((tWidget* )&zoomIncButCh2);

    WidgetAdd(WIDGET_ROOT, (tWidget*) &zoomDecButCh2);
    WidgetPaint((tWidget* )&zoomDecButCh2);
}

// printing the exact waveform in channel 2 display screen
void print_waveform_ch2()
{

    clear_screen_grid();

    float *wave;
    //wave form area :
    switch (ch2)
    {
    case 'n':
        wave = sine;
        break;
    case 's':
        wave = square;
        break;
    case 't':
        wave = tri;
        break;
    }

    int scale_factor = 20;
    uint32_t y_origin = 110;

    y_axisCh2[0] = y_origin + (int) ((scale_factor) * (ampCh2 * wave[0]));
    y_axis_zoomedCh2[0] = y_axisCh2[0];

    GrContextForegroundSet(&sContext, ClrGreenYellow);
    GrLineDrawH(&sContext, 0, 1, y_axisCh2[0]);

    for (int i = 1; i < 319; i++)
    {
        int wave_point = (((int) (i * freqCh2)) % MAX_SAMPLES);
        y_axisCh2[i] = y_origin
                + (int) ((scale_factor) * (ampCh2 * wave[wave_point]));
    }

    for (int i = 1; i < 319; i++)
    {
        y_axis_zoomedCh2[i] = y_axisCh2[i / zoom_scaleCh2];

        GrLineDrawV(&sContext, i, y_axis_zoomedCh2[i - 1], y_axis_zoomedCh2[i]);
        GrLineDrawH(&sContext, i, i + 1, y_axis_zoomedCh2[i]);
    }



    tRectangle Rect_ampCh2,Rect_freqCh2;

    // printing freq and amp of the waveform which is displayed

    printAmpStr(ampStrCh2,&ampCh2);
    makeRect(&Rect_ampCh2,250,15, 319,30,RECT_FREQAMP_COLOR,ampStrCh2);


    printFreqStr(freqStrCh2, &freqCh2);
    makeRect(&Rect_freqCh2,0,15, 70,30,RECT_FREQAMP_COLOR,freqStrCh2);

}





